#!/bin/bash

# CUDA_VISIBLE_DEVICES=7 nohup python run_AlphaEdit_editing.py \
#     --editing_method=AlphaEdit \
#     --hparams_dir=../hparams/AlphaEdit/llama-7b.yaml \
#     --data_dir=../data/ZsRE \
#     --ds_size=1000 \
#     --data_type=ZsRE \
#     --sequential_edit > run_alphaedit.log 2>&1 &

#!/bin/bash
 
editing_method="AlphaEdit"
hparams_dir="../hparams/AlphaEdit/llama3-8b-instruct.yaml"
# hparams_dir="../hparams/AlphaEdit/gpt2-xl.yaml" 
data_dir="../data/ZsRE" 
ds_size=2000
data_type="ZsRE" 
# data_dir="../data/CF"
# ds_size=5000
# data_type="CF" 
# type="na-2k"  
# type="base"     
# type="na_0-1_mask-0.9_postmask"                                             # na_0-1_mask-0.2_postmask
# type="na_0-1_mask_postmask_resonance_entropy_adaptive_mask_ratio_0.5_0.3"
# type="na_0-1_mask_postmask_resonance_entropy_adaptive_mask_ratio_0.3-0.4_0.2-0.3_AMPLIFY_FACTOR30"             # na_0-1_mask_postmask_resonance_ratio=0.3_burst_ratio=0.1

# type="na_0-1_mask_0.35—0.25"   
# type="na_0-1_mask_only_use_resonance"   
# type="na_0-1_mask_only_use_burst"   
# type="base-5k" 
# type="na_0-1_mask_postmask_resonance_entropy_adaptive_mask_ratio_0.3-0.4_0.2-0.3-5k"  
# type="na_0-1_neuron_analyze_0.3-0.2"

# type="na_0-1_mask_postmask_resonance_entropy_adaptive_mask_ratio_0.4-0.5_0.3-0.4-AMPLIFY_FACTOR=30"             # na_0-1_mask_postmask_resonance_ratio=0.3_burst_ratio=0.1
# type="na_0-1_mask_postmask_resonance_entropy_adaptive_mask_ratio_0.5-0.6_0.3-0.4"              # na_0-1_mask_postmask_resonance_ratio=0.3_burst_ratio=0.1
# type="na-0.3-0.4_0.2-0.3-5k-AMPLIFY_FACTOR=50"
# type="na-5k-0.45-0.5_0.4-0.45-AMPLIFY_FACTOR=30"


# type="NMKE-ge=0-1_sp=0-1"               # [0-1], [0-1]            OK

 
# type="NMKE-ge=0.2-0.3_sp=0.2-0.3"       # [0.2-0.3], [0.2-0.3]
# type="NMKE-ge=0.3-0.4_sp=0.2-0.3"       # [0.3-0.4], [0.2-0.3] 
# type="NMKE-ge=0.4-0.5_sp=0.2-0.3"       # [0.4-0.5], [0.2-0.3] 

# type="NMKE-ge=0-0.5_sp=0.2-0.3"         # [0-0.5], [0.2-0.3] 
# type="NMKE-ge=0.1-0.6_sp=0.2-0.3"       # [0.1-0.6], [0.2-0.3] 
# type="NMKE-ge=0.2-0.7_sp=0.2-0.3"       # [0.2-0.7], [0.2-0.3] 

# type="NMKE-ge=0.3-0.4_sp=0.1-0.2"     # [0.3-0.4], [0.1-0.2]
# type="NMKE-ge=0.3-0.4_sp=0.2-0.3"     # [0.3-0.4], [0.2-0.3]
# type="NMKE-ge=0.3-0.4_sp=0.3-0.4"     # [0.3-0.4], [0.3-0.4]

# type="NMKE-ge=0.3-0.4_sp=0-0.5"     # [0.3-0.4], [0-0.5]
# type="NMKE-ge=0.3-0.4_sp=0.1-0.6"     # [0.3-0.4], [0.1-0.6] 

hparams_base=$(basename "$hparams_dir" .yaml)

# 自动生成日志文件名
log_file="run_${editing_method}_${hparams_base}_${ds_size}_${data_type}_${type}.log"

# 打印日志文件名供检查
echo "Log file: ${log_file}"

# 运行命令
CUDA_VISIBLE_DEVICES=7 nohup python run_AlphaEdit_editing.py \
    --editing_method=${editing_method} \
    --hparams_dir=${hparams_dir} \
    --data_dir=${data_dir} \
    --ds_size=${ds_size} \
    --data_type=${data_type} \
    --sequential_edit > ${log_file} 2>&1 &


